﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/wlan/wlan_Result.h>
#include "../common.h"

namespace {

const size_t ThreadStackSize = 4096;  // スレッドのスタックサイズ
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack1[ ThreadStackSize ];
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack2[ ThreadStackSize ];
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack3[ ThreadStackSize ];
nn::os::ThreadType  g_Thread1;
nn::os::ThreadType  g_Thread2;
nn::os::ThreadType  g_Thread3;
}

void Test1(void* arg)
{
    nn::Result result;
    NN_UNUSED(arg);
    for( int i = 0; i < 10; i++ )
    {
        NN_LOG("InitializeLocalManager %d\n", i);
        nn::wlan::InitializeLocalManager();

        for( int j = 0; j < 10; j++ )
        {
            result = nn::wlan::Local::OpenClientMode();
            if( result.IsSuccess() )
            {
                NN_LOG("[LOCAL]OpenClientMode Success.\n");
            }
            else
            {
                NN_LOG("[LOCAL]OpenClientMode Failure.\n");
            }

            nn::os::SleepThread(nn::TimeSpan::FromSeconds(2));

            result = nn::wlan::Local::CloseClientMode();
            if( result.IsSuccess() )
            {
                NN_LOG("[LOCAL]CloseClientMode Success.\n");
            }
            else
            {
                NN_LOG("[LOCAL]CloseClientMode Failure.\n");
            }

            nn::os::SleepThread(nn::TimeSpan::FromSeconds(3));

            result = nn::wlan::Local::OpenMasterMode();
            if( result.IsSuccess() )
            {
                NN_LOG("[LOCAL]OpenMasterMode Success.\n");
            }
            else
            {
                NN_LOG("[LOCAL]OpenMasterMode Failure.\n");
            }

            nn::os::SleepThread(nn::TimeSpan::FromSeconds(2));

            result = nn::wlan::Local::CloseMasterMode();
            if( result.IsSuccess() )
            {
                NN_LOG("[LOCAL]CloseMasterMode Success.\n");
            }
            else
            {
                NN_LOG("[LOCAL]CloseMasterMode Failure.\n");
            }

            nn::os::SleepThread(nn::TimeSpan::FromSeconds(3));
        }

        nn::wlan::FinalizeLocalManager();
        NN_LOG("FinalizeLocalManager %d\n", i);
    }
}

void Test2(void* arg)
{
    NN_UNUSED(arg);
    for( int i = 0; i < 10; i++ )
    {
        NN_LOG("InitializeSocketManager %d\n", i);
        nn::wlan::InitializeSocketManager();

        nn::os::SleepThread(nn::TimeSpan::FromSeconds(10));

        nn::wlan::FinalizeSocketManager();
        NN_LOG("FinalizeSocketManager %d\n", i);
    }
}

void Test3(void* arg)
{
    NN_UNUSED(arg);
    nn::Result result;
    for( int i = 0; i < 10; i++ )
    {
        NN_LOG("InitializeInfraManager %d\n", i);
        nn::wlan::InitializeInfraManager();

        for( int j = 0; j < 10; j++ )
        {
            result = nn::wlan::Infra::OpenMode();
            if( result.IsSuccess() )
            {
                NN_LOG("[INFRA]OpenMode Success.\n");
            }
            else
            {
                NN_LOG("[INFRA]OpenMode Failure.\n");
            }

            nn::os::SleepThread(nn::TimeSpan::FromSeconds(3));

            result = nn::wlan::Infra::CloseMode();
            if( result.IsSuccess() )
            {
                NN_LOG("[INFRA]CloseMode Success.\n");
            }
            else
            {
                NN_LOG("[INFRA]CloseMode Failure.\n");
            }

            nn::os::SleepThread(nn::TimeSpan::FromSeconds(3));
        }

        nn::wlan::FinalizeInfraManager();
        NN_LOG("FinalizeInfraManager %d\n", i);
    }
}

extern "C" void nnMain()
{
    NN_LOG("\n\n Start WlanTest OpenClose \n\n");
    nn::Result result;

    WlanTest::SystemInitialize();

    result = nn::os::CreateThread( &g_Thread1, Test1, NULL, g_ThreadStack1, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread1." );
    nn::os::StartThread( &g_Thread1 );
    result = nn::os::CreateThread( &g_Thread2, Test2, NULL, g_ThreadStack2, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread2." );
    nn::os::StartThread( &g_Thread2 );
    result = nn::os::CreateThread( &g_Thread3, Test3, NULL, g_ThreadStack3, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread3." );
    nn::os::StartThread( &g_Thread3 );

    nn::os::WaitThread( &g_Thread1 );
    nn::os::DestroyThread( &g_Thread1 );

    nn::os::WaitThread( &g_Thread2 );
    nn::os::DestroyThread( &g_Thread2 );

    nn::os::WaitThread( &g_Thread3 );
    nn::os::DestroyThread( &g_Thread3 );

    WlanTest::SystemFinalize();

    NN_LOG("\n\n End WlanTest OpenClose \n\n");
}

