﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"
#include "ISceneChanger.h"

class SceneManager : public ISceneChanger, Task
{

private:
    BaseScene* m_scene;
    eScene m_nextScene;
    eScene m_currScene;
    eScene m_prevScene;

    bool m_isExit;

public:
    explicit SceneManager() NN_NOEXCEPT;
    void Initialize()  NN_NOEXCEPT override;
    void Finalize() NN_NOEXCEPT override;
    void Update() NN_NOEXCEPT override;
    void Draw(GraphicTools* pTools) NN_NOEXCEPT override;
    bool IsExit() NN_NOEXCEPT;

    // 引数 nextScene にシーンを変更する
    void ChangeScene(eScene NextScene) NN_NOEXCEPT override;
    eScene GetPrevScene() NN_NOEXCEPT override;
};
