﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstring>
#include <nn/fs.h>
#include <nn/fs/fs_Debug.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/util/util_FormatString.h>

class FsSdCard {

private :
    char m_filePath[256];
    bool m_IsMounted;
public :
    FsSdCard() NN_NOEXCEPT {};
    ~FsSdCard() NN_NOEXCEPT {};
    bool Initialize(const char* filePath) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    bool Append(const void* buf, size_t length) NN_NOEXCEPT;
};
