﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/gfx.h>
#include <nns/gfx/gfx_GraphicsFramework.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nns/gfx/gfx_PrimitiveRendererMeterDrawer.h>
#include <nns/gfx/gfx_PrimitiveRendererMeshRes.h>
#include <nn/util/util_Color.h>
#define NN_GFX_UTIL_DEBUGFONT_USE_DEFAULT_LOCALE_CHARSET
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include <nn/time/time_Api.h>
#include <nn/time/time_TimeZoneApi.h>
#include <nn/time/time_StandardUserSystemClock.h>

#include "ISceneChanger.h"
#include "Npad.h"
#include "Task.h"

static const size_t ThreadStackSize = 8192;
const nn::util::Unorm8x4 MY_GRAY = { { 0x20, 0x20, 0x20, 0xff } };
const nn::util::Unorm8x4 MY_PURPLE = { { 0xa9, 0xa9, 0xf5, 0xff } };
const nn::util::Unorm8x4 MY_DARK_BLUE = { {0x08, 0x29, 0x8A, 0xff } };
class BaseScene : public Task
{
public :
    static constexpr float SCREEN_WIDTH = 1280.f;
    static constexpr float SCREEN_HEIGHT = 720.f;
protected:
    // クラス所有元にシーン切り替えを伝えるインターフェイス
    ISceneChanger* m_SceneChanger;
    nn::time::CalendarTime m_calendarTime;

public :
    explicit BaseScene(ISceneChanger* pChanger) NN_NOEXCEPT;
    virtual ~BaseScene() NN_NOEXCEPT {};
    virtual void Initialize() NN_NOEXCEPT override {}
    virtual void Finalize() NN_NOEXCEPT override {};
    virtual void Update() NN_NOEXCEPT override {}
    virtual void Draw(GraphicTools* pTools) NN_NOEXCEPT override;
    static int ConvertChannelToId(uint16_t channel) NN_NOEXCEPT;
};
