﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Network.h"
#include <nn/nifm/nifm_ApiNetworkConnection.h>
#include <nn/nn_Log.h>
#include <nn/os/os_TickApi.h>


namespace ApConnectivityTest
{

// コンストラクタ
Network::WpsTask::WpsTask(nn::wlan::WpsMethod method, nn::bsdsocket::cfg::IfSettings ifSettings, const std::function<void(bool, const nn::TimeSpan&)>& callback) :
        Task(TaskType_Wps),
        m_WpsMethod(method),
        m_IfSettings(ifSettings),
        m_Callback(callback)
{
}


// デストラクタ
Network::WpsTask::~WpsTask()
{
}


// WPS 試行
void Network::WpsTask::Run()
{
    auto connection = new WlanConnection(m_WpsMethod, m_IfSettings);

    auto requestBeginTick = nn::os::GetSystemTick();
    auto result = connection->Connect();
    auto requestEndTick = nn::os::GetSystemTick();

    if (result)
    {
        Network::GetInstance().m_pConnection = connection;
    }
    else
    {
        delete connection;
    }

    m_Callback(result, (requestEndTick - requestBeginTick).ToTimeSpan());
}

}
