﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_DebugPad.h>
#include <nn/hid/hid_TouchScreen.h>


namespace ApConnectivityTest
{

class App;

class Hid
{
    friend App;

private:
    struct TouchState
    {
        bool valid;
        unsigned int frameCount;
        nn::hid::TouchState state;
    };

public:
    void Initialize();
    void Finalize();

    void Refresh();

    const nn::hid::DebugPadButtonSet& GetKeyDown() const;
    const nn::hid::DebugPadButtonSet& GetKeyUp() const;
    const nn::hid::DebugPadButtonSet& GetKeyPress() const;

    const bool GetTouchDown(nn::hid::TouchState* pOut, size_t index) const;
    const bool GetTouchUp(nn::hid::TouchState* pOut, size_t index) const;
    const bool GetTouchPress(nn::hid::TouchState* pOut, size_t index) const;

private:
    Hid();
    virtual ~Hid();

private:
    nn::hid::DebugPadState m_LastPadState;
    unsigned int m_PadStateCounts[nn::hid::DebugPadButtonSet::StorageBitCount];

    nn::hid::DebugPadButtonSet m_DownPadButtonSet;
    nn::hid::DebugPadButtonSet m_UpPadButtonSet;
    nn::hid::DebugPadButtonSet m_PressPadButtonSet;

    TouchState m_LastTouchState[nn::hid::TouchStateCountMax];

    static const unsigned int g_PadRepeatTime;
    static const unsigned int g_PadRepeatCycle;
    static const unsigned int g_TouchRepeatTime;
};

}
