﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Hid.h"
#include "UI.h"
#include <nn/os/os_TimerEventTypes.h>


namespace ApConnectivityTest
{


class App
{
public:
    App();
    virtual ~App();

    void Run();

    static UI::UI& GetUi();
    static Hid& GetHid();

protected:
    void Exit();

private:
    UI::UI m_Ui;
    Hid m_Hid;

    static App* g_Instance;

    bool m_Exit;

    int m_FpsCount;
    nn::os::TimerEvent m_FpsCountTimerEvent;
};

}
