﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "App.h"
#include "Menu.h"
#include "Network.h"
#include <nn/nifm/nifm_TypesNetworkProfile.h>


namespace ApConnectivityTest
{

class ApConnectivityTestApp : public App
{
private:
    enum MenuState
    {
        MenuState_Disconnect,
        MenuState_Connecting,
        MenuState_Connect,
        MenuState_PingStart,
        MenuState_PingStop,
        MenuState_IperfStart,
        MenuState_IperfStop,
    };

    struct ConnectNetworkSetting
    {
        nn::nifm::NetworkProfileData profile;
        bool mixedMode;
        int tryCount;
    };

public:
    ApConnectivityTestApp();
    virtual ~ApConnectivityTestApp();

private:
    void InitializeMenu();

    void ApIpSettingMenuItem(const std::string& value);
    void ApIpAddressMenuItem();
    void ApSubnetMaskMenuItem();
    void ApDefaultGatewayMenuItem();
    void ApDnsSettingMenuItem(const std::string& value);
    void ApPreferredDnsMenuItem();
    void ApAlternateDnsMenuItem();
    void ApMtuMenuItem();
    void ApProxySettingMenuItem(const std::string& value);
    void ApProxyAddressMenuItem();
    void ApProxyPortMenuItem();
    void ConnectMenuCallback();
    void DisconnectMenuCallback();
    void WpsPbcMenuCallback();
    void WpsPinMenuCallback();
    void EthernetConnectMenuCallback();
    void PingSizeMenuCallback();
    void StartPingCallback();
    void StopPingCallback();
    void IperfNumInstancesMenuCallback();
    void IperfCommandlineMenuCallback(size_t index);
    void StartIperfCallback();
    void StopIperfCallback();
    void QuitApplicationMenuCallback();

    void AuthenticationChangeCallback(const std::string& value);
    void EncryptionChangeCallback(const std::string& value);

    void ConnectNetwork();
    void ConnectNetworkCallback(bool result, const nn::TimeSpan& elapsedTime);

    void WpsConnectCallback(bool result, const nn::TimeSpan& elapsedTime);

    void PingCallback();

    void IperfExitCallback();

    void LoadConnectSettings(ConnectNetworkSetting* pOut);

    void SetMenuState(MenuState state);

private:
    std::shared_ptr<UI::Menu> m_Menu;
    std::shared_ptr<UI::SubMenuItem> m_ApMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_ApSsidMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_ApAuthenticationMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_ApEncryptionMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_ApSharedKeyMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_ApIpSettingMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApIpAddressMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApSubnetMaskMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApDefaultGatewayMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_ApDnsSettingMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApPreferredDnsMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApAlternateDnsMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApMtuMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_ApProxySettingMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApProxyAddressMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApProxyPortMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_ApRetryCountMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApConnectMenuItem;
    std::shared_ptr<UI::MenuItem> m_ApDisconnectMenuItem;
    std::shared_ptr<UI::SubMenuItem> m_WpsMenuItem;
    std::shared_ptr<UI::MenuItem> m_WpsPbcMenuItem;
    std::shared_ptr<UI::MenuItem> m_WpsPinMenuItem;
    std::shared_ptr<UI::SubMenuItem> m_EthernetMenuItem;
    std::shared_ptr<UI::MenuItem> m_EthernetConnectMenuItem;
    std::shared_ptr<UI::SubMenuItem> m_PingMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_PingDestinationMenuItem;
    std::shared_ptr<UI::MenuItem> m_PingSizeMenuItem;
    std::shared_ptr<UI::ValueSelectSubMenuItem> m_PingRepeatCountMenuItem;
    std::shared_ptr<UI::MenuItem> m_PingStartMenuItem;
    std::shared_ptr<UI::MenuItem> m_PingStopMenuItem;
    std::shared_ptr<UI::SubMenuItem> m_IperfMenuItem;
    std::shared_ptr<UI::MenuItem> m_IperfCommandlineMenuItem;
    std::shared_ptr<UI::MenuItem> m_IperfStartMenuItem;
    std::shared_ptr<UI::MenuItem> m_IperfStopMenuItem;
    std::shared_ptr<UI::SubMenuItem> m_MiscMenuItem;
    std::shared_ptr<UI::MenuItem> m_MiscQuitApplicationMenuItem;

    bool m_NifmAdminMode;

    ConnectNetworkSetting m_ConnectNetworkSetting;
    int m_ConnectTryCount;

    int m_PingSuccessCount;
    int m_PingResponseCount;
    Network::PingController m_PingController;
};

}
