﻿var KEY_CODE_ENTER = 13;

var forbidsControl = false;
var touchIdentifier = null;

var playBtn = document.querySelector('#play');
var backBtn = document.querySelector('#back');

var play = function() {
  if (forbidsControl) {
    return;
  }
  forbidsControl = true;
  playBtn.classList.add('hover');
  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeWebLinkDecide');
  }
  setTimeout(function() {
    playBtn.classList.remove('hover');
    location.href = playBtn.href;
    forbidsControl = false;
  }, 200);
};

var back = function() {
  if (forbidsControl) {
    return;
  }
  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeFooterDecideBack');
  }
  location.href = backBtn.href;
};

var isExcessiveTouch = function(event) {
  return event.targetTouches[0].identifier !== event.touches[0].identifier;
};

var findTargetTouch = function(event) {
  var i, changedTouch;
  for (i = 0; i < event.changedTouches.length; ++i) {
    changedTouch = event.changedTouches[i];
    if (changedTouch.target === event.currentTarget &&
        changedTouch.identifier === touchIdentifier) {
      return changedTouch;
    }
  }
  return null;
}

playBtn.addEventListener('focus', function(event) {
  var target = event.currentTarget;
  if (!event.relatedTarget) {
    target.focus();
    target.classList.add('focus');
  }
});

playBtn.addEventListener('blur', function(event) {
  var target = event.currentTarget;
  if (!event.relatedTarget) {
    target.focus();
  } else {
    target.classList.remove('focus');
  }
});

playBtn.addEventListener('touchstart', function(event) {
  var target = event.currentTarget;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  if (isExcessiveTouch(event)) {
    return;
  }
  touchIdentifier = event.targetTouches[0].identifier;
  if (target.classList.contains('hover')) {
    return;
  }
  if (document.activeElement === target && window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeWebNaviFocus');
  }
  target.focus();
  target.classList.add('hover');
});

playBtn.addEventListener('touchmove', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
    target.classList.add('hover');
  }
  else {
    target.classList.remove('hover');
  }
});

playBtn.addEventListener('touchend', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  touchIdentifier = null;
  target.classList.remove('hover');
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
      rect.top <= coord.y && coord.y <= rect.bottom) {
    play();
  }
});

playBtn.addEventListener('touchcancel', function(event) {
  var target = event.currentTarget;
  target.classList.remove('hover');
});

playBtn.addEventListener('keydown', function(event) {
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  if (event.keyCode === KEY_CODE_ENTER) {
    play();
  }
});

backBtn.addEventListener('touchstart', function(event) {
  var target = event.currentTarget;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  if (isExcessiveTouch(event)) {
    return;
  }
  touchIdentifier = event.targetTouches[0].identifier;
  if (target.classList.contains('hover')) {
    return;
  }
  if (window.nx && window.nx.playSystemSe) {
    window.nx.playSystemSe('SeWebNaviFocus');
  }
  target.classList.add('hover');
});

backBtn.addEventListener('touchmove', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
    rect.top <= coord.y && coord.y <= rect.bottom) {
    target.classList.add('hover');
  }
  else {
    target.classList.remove('hover');
  }
});

backBtn.addEventListener('touchend', function(event) {
  var target = event.currentTarget, targetTouch, coord, rect;
  event.preventDefault();
  if (forbidsControl) {
    return;
  }
  var targetTouch = findTargetTouch(event);
  if (!targetTouch) {
    return;
  }
  touchIdentifier = null;
  target.classList.remove('hover');
  coord = {
    x: targetTouch.clientX,
    y: targetTouch.clientY
  };
  rect = target.getBoundingClientRect();
  if (rect.left <= coord.x && coord.x <= rect.right &&
    rect.top <= coord.y && coord.y <= rect.bottom) {
    back();
  }
});

backBtn.addEventListener('touchcancel', function(event) {
  var target = event.currentTarget;
  target.classList.remove('hover');
});

if (window.nx && window.nx.footer && window.nx.footer.setAssign) {
  window.nx.footer.setAssign('B', null, back, {
    se: ''
  });
}

if (window.nx && window.nx.footer && window.nx.footer.unsetAssign) {
  window.nx.footer.unsetAssign('X');
}
