﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include "Controller.h"

namespace
{
    nn::hid::NpadIdType s_Ids[] =
    {
        nn::hid::NpadId::No1,
        nn::hid::NpadId::Handheld,
    };
}

void Controller::Initialize() NN_NOEXCEPT
{
    nn::hid::InitializeNpad();
    nn::hid::SetSupportedNpadStyleSet(nn::hid::NpadStyleJoyDual::Mask |
                                      nn::hid::NpadStyleHandheld::Mask);

    nn::hid::SetSupportedNpadIdType(s_Ids, sizeof(s_Ids) / sizeof(s_Ids[0]));
}

Controller::Controller() NN_NOEXCEPT
    : m_Current{}
    , m_Last{}
{
}

void Controller::Update() NN_NOEXCEPT
{
    std::memcpy(&m_Last, &m_Current, sizeof(m_Last));

    for( int i = 0; i < sizeof(s_Ids) / sizeof(s_Ids[0]); ++i )
    {
        nn::hid::NpadStyleSet style = nn::hid::GetNpadStyleSet(s_Ids[i]);

        if( style.Test<nn::hid::NpadStyleJoyDual>() )
        {
            nn::hid::NpadJoyDualState state;
            nn::hid::GetNpadState(&state, s_Ids[i]);
            m_Current = state.buttons;
        }
        else
        {
            if( style.Test<nn::hid::NpadStyleHandheld>() )
            {
                nn::hid::NpadHandheldState state;
                nn::hid::GetNpadState(&state, s_Ids[i]);
                m_Current = state.buttons;
            }
        }
    }
}
