﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include "ContrastRatioMenuItem.h"
#include "Utility.h"

ContrastRatioMenuItem::ContrastRatioMenuItem(nn::vi::Display* pDisplay, float ratio) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
    , m_Ratio(ratio)
{
}

void ContrastRatioMenuItem::Render() const NN_NOEXCEPT
{
    NN_LOG("%f", m_Ratio);
}

void ContrastRatioMenuItem::Select() NN_NOEXCEPT
{
    // The contrast ratio setting will apply to both LCD and HDMI when using the
    // default display.
    if( nn::vi::SetDisplayContrastRatio(m_pDisplay, m_Ratio).IsSuccess() )
    {
        // These settings must be written to NAND before the next mode switch
        // occurs or they will be overwritten.
        // This restriction might be lifted in the future.
        nn::settings::system::TvSettings settings;
        nn::settings::system::GetTvSettings(&settings);

        settings.contrastRatio = m_Ratio;

        nn::settings::system::SetTvSettings(settings);
    }
}
