﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include "CmuModeMenuItem.h"
#include "Utility.h"

CmuModeMenuItem::CmuModeMenuItem(nn::vi::Display* pDisplay, nn::vi::CmuMode mode) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
    , m_Mode(mode)
{
}

void CmuModeMenuItem::Render() const NN_NOEXCEPT
{
    NN_LOG("%s", ToString(m_Mode));
}

void CmuModeMenuItem::Select() NN_NOEXCEPT
{
    // The CMU mode setting will apply to both LCD and HDMI when using the
    // default display.
    if( nn::vi::SetDisplayCmuMode(m_pDisplay, m_Mode).IsSuccess() )
    {
        // These settings must be written to NAND before the next mode switch
        // occurs or they will be overwritten.
        // This restriction might be lifted in the future.
        nn::settings::system::TvSettings settings;
        nn::settings::system::GetTvSettings(&settings);

        settings.cmuMode = ToSettings(m_Mode);

        nn::settings::system::SetTvSettings(settings);
    }
}
