::=============================================================================
::  Vfx バイナリコンバート
::=============================================================================
@echo off
set WORKING_DIR=%~dp0
pushd %WORKING_DIR%

set NINTENDO_SDK_ROOT=%~1
set CONTENT_DIR=%~2
set PLATFORM=%~3
set EFFECT_MAKER_PATH=%NINTENDO_SDK_ROOT%\Tools\Graphics\EffectMaker\EffectConverter.exe
set EFFECT_MAKER_COMMAND=%EFFECT_MAKER_PATH% --platform %PLATFORM% --convert-list ConvertList.xml -o %CONTENT_DIR%\demo.ptcl

echo Resource conversion start.
echo   NintendoSdkRoot: %NINTENDO_SDK_ROOT%
echo   ContentDir: %CONTENT_DIR%
echo   WorkingDir: %WORKING_DIR%

echo Copy .eset files...
if exist %CONTENT_DIR% (
    rmdir /S /Q %CONTENT_DIR%
)
mkdir %CONTENT_DIR%
xcopy /D /S /R /Y /I /K %NINTENDO_SDK_ROOT%\Samples\Sources\Resources\Vfx\Eset %WORKING_DIR%\Eset

if exist %CONTENT_DIR%\demo.ptcl (
    del /Q /F /S %CONTENT_DIR%\demo.ptcl
)

echo Execute binary conversion.
echo   %EFFECT_MAKER_COMMAND%
%EFFECT_MAKER_COMMAND%

if not exist %CONTENT_DIR%\demo.ptcl (
    echo [Error] Vfx binary doesn't exist !!!
)
echo Resource conversion has finished.

popd
@echo on
