﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/


//--------------------------------------------------------------
// 位置調整
//--------------------------------------------------------------
#define USE_USR_ADJUSTMENT_WORLD_POSITION
void AdjustmentWorldPosition()
{
}

//---------------------------------------------------
// 最終出力調整
//---------------------------------------------------
#define USE_USR_FINAL_ADJUSTMENT_VERTEX_PROCSS
void FinalAdjustmentVertexProcess()
{
#ifdef CUSTOM_SHADER_INDEX_1
#if defined( RESERVED_SHADER_1 ) || defined( RESERVED_SHADER_2 )
#ifdef CUSTOM_SHADER_FLAG_0

#if defined( RESERVED_SHADER_1 )
    float sysStripePointID = ( sysEmitterPluginAttr2.w );
    float sysStripePointSum = sysEmitterPluginUniformBlockParam4.y;
    float sysStripeHeadAlpha = sysEmitterPluginUniformBlockParam1.x;
    float sysStripeTailAlpha = sysEmitterPluginUniformBlockParam1.y;
#elif defined( RESERVED_SHADER_2 )
    float sysStripePointID = ( sysEmitterPluginAttr1.w );
    float sysStripePointSum = sysEmitterPluginUniformBlockParam4.y;
    float sysStripeHeadAlpha = sysEmitterPluginUniformBlockParam1.x;
    float sysStripeTailAlpha = sysEmitterPluginUniformBlockParam1.y;
#endif

    // マスターアルファ値を再計算
    //----------------------------------------------------------------
    // MEMO: 切片 + 傾きとしては以下の式の通り。コードはその展開後。
    //       rangeAlpha = clamp( ( 2.0 - alphaPos ) - ( ( 1.0 - sysEmitterFadeAlpha ) * 2 ), 0.0, 1.0 );
    //----------------------------------------------------------------
    float alphaPos = sysStripePointID / ( sysStripePointSum - 1 );
    float rangeAlpha = clamp( ( 2 * sysEmitterFadeAlpha - alphaPos ), 0.0, 1.0 );

    sysMasterAlpha = alphaPos * ( sysStripeTailAlpha - sysStripeHeadAlpha ) + sysStripeHeadAlpha;
    sysMasterAlpha *= sysPtclAlphaRate * rangeAlpha;

#endif
#endif
#endif

}
