﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#if defined( NN_BUILD_CONFIG_OS_WIN32)
    #include "OsInterruptEvent-os.win32.h"
#elif defined( NN_BUILD_CONFIG_OS_HORIZON )
    #if defined( NN_BUILD_CONFIG_HARDWARE_BDSLIMX6 )
        #include "OsInterruptEvent-hw.imx6.h"
    #elif defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 )
        #include "OsInterruptEvent-hw.tk1.h"
    #elif defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 ) || \
          defined( NN_BUILD_CONFIG_HARDWARE_NX )
        #include "OsInterruptEvent-hw.tk2.h"
    #elif defined( NN_BUILD_CONFIG_HARDWARE_SMMA53 )
        #include "OsInterruptEvent-hw.smma53.h"
    #elif defined( NN_BUILD_CONFIG_HARDWARE_JUNO )
        #include "OsInterruptEvent-hw.juno.h"
    #else

namespace nns { namespace os { namespace interruptEvent {

//---------------------------------------------------------------------------
//  上記ターゲット以外の環境でビルドエラーを回避するため。
//  サンプルとしては未対応。
//
const nn::os::InterruptName TimerInterruptName = 0;

inline void ClearTimerInterruptStatus() NN_NOEXCEPT { /* Do nothing */ }
inline void StartTimerInterrupt()       NN_NOEXCEPT { /* Do nothing */ }
inline void StopTimerInterrupt()        NN_NOEXCEPT { /* Do nothing */ }

//---------------------------------------------------------------------------

}}} // namespace nns::os::interruptEvent

    #endif
#endif
