﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>
#include <nn/dd.h>

#if !defined( NN_BUILD_CONFIG_HARDWARE_BDSLIMX6 )
    #error  "BDSLIMX6 ボード向けのビルドではありません。"
#endif

namespace nns { namespace os { namespace interruptEvent {

//---------------------------------------------------------------------------

const int TimerInterruptName = 87;      // Interrupt Number for GPT

const int GptPeripheralClock = (132 / 2) * 1000 * 1000;  // 66MHz

// Physical address of GPT register
const nn::dd::PhysicalAddress TimerRegisterPhysicalAddress = 0x02098000;
const size_t                  TimerRegisterRegionSize      = 0x00004000;

//---------------------------------------------------------------------------

void ClearTimerInterruptStatus() NN_NOEXCEPT;
void StartTimerInterrupt() NN_NOEXCEPT;
void StopTimerInterrupt() NN_NOEXCEPT;

//---------------------------------------------------------------------------

}}} // namespace nns::os::interruptEvent

