#!/bin/bash
#-----------------------------------------------------------------------------
# １つ上にある Samples/Sources/Applications/ 以下にあるディレクトリのうち、
# Os, Dd, Init の接頭辞から始まるディレクトリ（ただし、OsAll は除く）に対して
# nact によるフルビルドを実行するスクリプトです。
#
# 以下のように Cygwin 上から、OsAll/ 以下で実行して下さい。
# 必要な platforms は随時追加して下さい。
#
# cygwin> cd Samples/Sources/Applications/OsAll/
# cygwin> ./BuildAllByNact.sh
#
LIST=`find .. -type d -name "Dd*" -or -type d -name "Os*" -or -type d -name "Init*" | grep -v OsAll`
DIRFLAGS=${LIST//\.\.\//-d ./}
NACT="nact -j 4 outputs=samples BUILD=full"
pushd ../ ; $NACT platforms=Win32,Win64 $DIRFLAGS ; popd
pushd ../ ; $NACT platforms=Win32_VS2013,Win64_VS2013 $DIRFLAGS ; popd
pushd ../ ; $NACT platforms=Win32_VS2015,Win64_VS2015 $DIRFLAGS ; popd
pushd ../ ; $NACT platforms=jetson-tk2,jetson-tk2-a64 $DIRFLAGS ; popd
