﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "NnsLogCustomDrawGraphicsSystem.h"

class Showing
{
    NN_DISALLOW_COPY(Showing);
    NN_DISALLOW_MOVE(Showing);
public:
    Showing() NN_NOEXCEPT;
    ~Showing() NN_NOEXCEPT;

private:
    static const size_t ThreadStackSize = 128 * 1024;

private:
    void ThreadFuncImpl() NN_NOEXCEPT;
    static void ThreadFunc(void* pArg) NN_NOEXCEPT;

private:
    GraphicsSystem* m_pGraphicsSystem;

    char*  m_pThreadStack;
    nn::os::ThreadType m_Thread; // スレッド
    nn::os::EventType m_EventType;
};
