﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/socket.h>
#include <curl/curl.h>

// Build options
#define MOUNT_SDCARD
// You must link libnn_profiler.a to use the profiler
// #define ENABLE_PROFILER

//  Heap Configuration
const int FsHeapSize = 512 * 1024;
const int mmHeapSize = 512 << 20;
const size_t  g_GraphicsSystemMemorySize = 8 * 1024 * 1024;
const int64_t padHoldScrollSpeed = 1000000;

//Assuming max 4k resolution
const int MAX_NVN_TEXTURE_WIDTH = 3840;
const int MAX_NVN_TEXTURE_HEIGHT = 2160;
const int MAX_NVN_BUFFER_SIZE = 2 * MAX_NVN_TEXTURE_WIDTH * MAX_NVN_TEXTURE_HEIGHT;
