﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nns {
namespace libupnp {

char g_pUpnpDeviceNintendoGameXml[] = "<?xml version=\"1.0\"?>\r\n"
"<root xmlns=\"urn:schemas-upnp-org:device-1-0\">\r\n"
"  <specVersion>\r\n"
"    <major>1</major>\r\n"
"    <minor>0</minor>\r\n"
"  </specVersion>\r\n"
"  <device>\r\n"
"   <deviceType>urn:schemas-upnp-org:device:nintendogame:1</deviceType>\r\n"
"    <friendlyName>UPnP Nintendo Game</friendlyName>\r\n"
"    <manufacturer>Nintendo</manufacturer>\r\n"
"    <manufacturerURL>http://www.nintendo.com</manufacturerURL>\r\n"
"    <modelDescription>UPnP Nintendo Game 1.0</modelDescription>\r\n"
"    <modelName>NintendoGame</modelName>\r\n"
"    <modelNumber>1.0</modelNumber>\r\n"
"    <modelURL>http://www.nintendo.com</modelURL>\r\n"
"    <serialNumber>123456789001</serialNumber>\r\n"
"    <UDN>uuid:Upnp-NintendoGame-1_0-1234567899999</UDN>\r\n"
"    <UPC>123456789</UPC>\r\n"
"    <serviceList>\r\n"
"      <service>\r\n"
"        <serviceType>urn:schemas-upnp-org:service:nintendogamecontrol:1</serviceType>\r\n"
"        <serviceId>urn:upnp-org:serviceId:nintendogamecontrol1</serviceId>\r\n"
"        <controlURL>/upnp/control/nintendogamecontrol1</controlURL>\r\n"
"        <eventSubURL>/upnp/event/nintendogamecontrol1</eventSubURL>\r\n"
"        <SCPDURL>/nintendogamecontrolSCPD.xml</SCPDURL>\r\n"
"      </service>\r\n"
"    </serviceList>\r\n"
"   <presentationURL>/nintendogamepres.html</presentationURL>\r\n"
"  </device>\r\n"
"</root>\r\n";

char g_pUpnpDeviceNintendoGameControlXml[] = "<?xml version=\"1.0\"?>\r\n"
"<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">\r\n"
"  <specVersion>\r\n"
"    <major>1</major>\r\n"
"    <minor>0</minor>\r\n"
"  </specVersion>\r\n"
"  <actionList>\r\n"
"    <action>\r\n"
"      <name>SetA</name>\r\n"
"      <argumentList>\r\n"
"        <argument>\r\n"
"         <name>A</name>\r\n"
"         <retval />\r\n"
"         <relatedStateVariable>ValueA</relatedStateVariable>\r\n"
"         <direction>in</direction>\r\n"
"        </argument>\r\n"
"      </argumentList>\r\n"
"   </action>\r\n"
"    <action>\r\n"
"      <name>GetA</name>\r\n"
"      <argumentList>\r\n"
"        <argument>\r\n"
"         <name>A</name>\r\n"
"         <retval />\r\n"
"         <relatedStateVariable>ValueA</relatedStateVariable>\r\n"
"         <direction>out</direction>\r\n"
"        </argument>\r\n"
"      </argumentList>\r\n"
"   </action>\r\n"
"    <action>\r\n"
"      <name>SetB</name>\r\n"
"      <argumentList>\r\n"
"        <argument>\r\n"
"         <name>B</name>\r\n"
"         <retval />\r\n"
"         <relatedStateVariable>ValueA</relatedStateVariable>\r\n"
"         <direction>in</direction>\r\n"
"        </argument>\r\n"
"      </argumentList>\r\n"
"   </action>\r\n"
"    <action>\r\n"
"      <name>GetB</name>\r\n"
"      <argumentList>\r\n"
"        <argument>\r\n"
"         <name>B</name>\r\n"
"         <retval />\r\n"
"         <relatedStateVariable>ValueA</relatedStateVariable>\r\n"
"         <direction>out</direction>\r\n"
"        </argument>\r\n"
"      </argumentList>\r\n"
"   </action>\r\n"
"    <action>\r\n"
"      <name>SetC</name>\r\n"
"      <argumentList>\r\n"
"        <argument>\r\n"
"         <name>C</name>\r\n"
"         <retval />\r\n"
"         <relatedStateVariable>ValueA</relatedStateVariable>\r\n"
"         <direction>in</direction>\r\n"
"        </argument>\r\n"
"      </argumentList>\r\n"
"   </action>\r\n"
"    <action>\r\n"
"      <name>GetC</name>\r\n"
"      <argumentList>\r\n"
"        <argument>\r\n"
"         <name>C</name>\r\n"
"         <retval />\r\n"
"         <relatedStateVariable>ValueA</relatedStateVariable>\r\n"
"         <direction>out</direction>\r\n"
"        </argument>\r\n"
"      </argumentList>\r\n"
"   </action>\r\n"
"  </actionList>\r\n"
"  <serviceStateTable>\r\n"
"    <stateVariable sendEvents=\"yes\">\r\n"
"      <name>A</name>\r\n"
"      <dataType>i4</dataType>\r\n"
"        <allowedValueRange>\r\n"
"          <minimum>0</minimum>\r\n"
"          <maximum>7</maximum>\r\n"
"          <step>1</step>\r\n"
"       </allowedValueRange>\r\n"
"      <defaultValue>0</defaultValue>\r\n"
"    </stateVariable>\r\n"
"    <stateVariable sendEvents=\"yes\">\r\n"
"      <name>B</name>\r\n"
"      <dataType>i4</dataType>\r\n"
"        <allowedValueRange>\r\n"
"          <minimum>0</minimum>\r\n"
"          <maximum>7</maximum>\r\n"
"          <step>1</step>\r\n"
"       </allowedValueRange>\r\n"
"      <defaultValue>0</defaultValue>\r\n"
"    </stateVariable>\r\n"
"    <stateVariable sendEvents=\"yes\">\r\n"
"      <name>C</name>\r\n"
"      <dataType>i4</dataType>\r\n"
"        <allowedValueRange>\r\n"
"          <minimum>0</minimum>\r\n"
"          <maximum>7</maximum>\r\n"
"          <step>1</step>\r\n"
"       </allowedValueRange>\r\n"
"      <defaultValue>0</defaultValue>\r\n"
"    </stateVariable>\r\n"
"  </serviceStateTable>\r\n"
"</scpd>\r\n";

char g_pUpnpDeviceNintendoGamePresentationHtml[] = "<HTML>\r\n"
"<HEAD>\r\n"
"<BODY>\r\n"
"<H1>It works!</H1>\r\n"
"<P>This is the default web page for this server.</P>\r\n"
"<P>The web server software is running but no content has been added, yet.</P>\r\n"
"</BODY>\r\n"
"</HEAD>\r\n"
"</HTML>\r\n";

}} // namespace nns / libupnp
