﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nn/nn_Common.h>
#include <nn/lcs.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/os.h>

const size_t MemoryHeapSize = 256 * 1024 * 1024;
const size_t MallocHeapSize = 128 * 1024 * 1024;

const int ApplicationCountMax = 32;
const int ApplicationControlDataSize = 128 * 1024;
const int ScanResultCountMax = nn::lcs::ScanResultCountMax;
const int ThreadStackSize = 32 * 1024;
const int MonitorThreadPriority = nn::os::DefaultThreadPriority + 1;
const int UpdateThreadPriority = nn::os::DefaultThreadPriority + 2;

enum ApplicationState
{
    ApplicationState_Initialized,
    ApplicationState_ListUpApplication,
    ApplicationState_HostOpened,
    ApplicationState_Scaned,
    ApplicationState_ClientJoined,
    ApplicationState_Transferring,
    ApplicationState_Suspending,
    ApplicationState_Resuming,
    ApplicationState_SessionEnd,
};

struct ApplicationResource
{
    bool isRunning;
    nn::lcs::Config config;
    nn::ncm::ApplicationId sharableAppId[ApplicationCountMax];
    int sharableAppCount;
    nn::lcs::SessionInfo sessionInfo[ScanResultCountMax];
    int sessionCount;
    nn::lcs::NodeInfo nodeInfo[nn::lcs::NodeCountMax];
    int nodeCount;
    size_t requiredStorageSize;
    nn::lcs::ContentsShareFailureReason failureReason;
    nn::lcs::SuspendedReason suspendedReason;
    int cursor;
    int cursorMax;
    bool isAcceptPolicy;
    nn::os::ThreadType monitorThread;
    nn::os::SystemEventType stateChangeEvent;
    nn::os::EventType cancelEvent;
    ApplicationState appState;
};
