﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "IrSensorModeState.h"

#include <vector>

class PositionReaderModeState : public IrSensorModeState
{
public:
    PositionReaderModeState(IrSensorMode* pNextProcessor, int* pMenuSelection, nn::irsensor::IrCameraHandle irCameraHandle);

    void Start() NN_OVERRIDE;
    void Update() NN_OVERRIDE;
    void Render(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::gfx::CommandBuffer* pCommandBuffer, int index) NN_OVERRIDE;

private:
    const nn::util::Unorm8x4 GetCaptureStateColor();

private:
    nn::irsensor::MarkerPositionReaderState m_lastState;

    static size_t const PositionMaxCount = 2048;
    std::vector< std::pair<nn::util::Float2, bool> > m_PositionList;
    nn::util::Float2 m_CurrentPosition;

    // related to drawing
    float m_DrawScale;

    // calculated on system
    nn::util::Matrix4x3fType m_RotationMatrix;
    bool m_LernWarning;
};
