﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/hid_Mouse.h>
#include <nn/vi/vi_Layer.h>

#if defined(NN_BUILD_TARGET_PLATFORM_OS_NN)
#include <nn/hid/hid_TouchScreen.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NPadJoyDual.h>
#include <nn/hid/hid_SixAxisSensor.h>
#endif

struct InputData
{
    nn::hid::DebugPadState          debugPadState;
    nn::hid::KeyboardState          keyboardState;
    nn::hid::MouseState             mouseState;
#if defined(NN_BUILD_TARGET_PLATFORM_OS_NN)
    nn::hid::TouchScreenState<1>    touchScreenState;
    nn::hid::NpadHandheldState      npadHandheldState;
    nn::hid::NpadJoyDualState       npadJoyDualState;

    nn::hid::SixAxisSensorState     sixAxisSensorState;
#endif
};

struct ApplicationInputs
{
    InputData                       current;
    InputData                       previous;

#if defined(NN_BUILD_TARGET_PLATFORM_OS_NN)
    nn::hid::SixAxisSensorHandle    sixAxisSensorHandle;
#endif

};

void InitializeApplicationInputs(nn::vi::Layer* pLayer, ApplicationInputs* pApplicationInputs);
void FinalizeApplicationInputs(ApplicationInputs* pApplicationInputs);

void GetApplicationInputs(nn::vi::Layer* pLayer, ApplicationInputs* pApplicationInputs);
void UpdateDdguiInputs(const ApplicationInputs* pUserInputs);

bool TestToggleDebugGui(const ApplicationInputs* pApplicationInputs);

void OnMouseMoveFunction(int x, int y, void* pUserData);
