﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#if defined(NN_BUILD_TARGET_PLATFORM_OS_NN)

#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_SixAxisSensor.h>


bool InitializeSixAxis(
    nn::hid::SixAxisSensorHandle* pOutHandle,
    const nn::hid::NpadIdType& npadIdType,
    int index);
void FinalizeSixAxis(nn::hid::SixAxisSensorHandle handle);
bool UpdateSixAxis(
    nn::hid::SixAxisSensorState* pOutSixAxisSensorState,
    nn::hid::SixAxisSensorHandle handle);


#endif
