﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.Htcs
{
    public class TargetList : IEnumerable<Target>
    {
        private List<Target> items = new List<Target>();

        public TargetList()
        {
        }

        internal TargetList(XElement xElement)
        {
            items.AddRange(
                xElement.Elements(Target.XElementName).Select(x => new Target(x)));
        }

        // TORIAEZU ユーザに渡した後は呼ばないこと
        internal void Add(Target item)
        {
            items.Add(item);
        }

        // TORIAEZU ユーザに渡した後は呼ばないこと
        internal void Remove(Target target)
        {
            items.RemoveAt(items.FindIndex(s => s == target));
        }

        public const string XElementName = "TargetList";
        internal XElement ToXElement()
        {
            return new XElement(XElementName,
                items.Select(s => s.ToXElement()));
        }

        #region "IEnumerable<Target> メンバー"

        public IEnumerator<Target> GetEnumerator()
        {
            return items.GetEnumerator();
        }

        #endregion

        #region "IEnumerable メンバー"

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            return items.GetEnumerator();
        }

        #endregion
    }
}
