﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_Vector.h>

struct Sphere
{
    enum VertexColorPattern
    {
        VertexColorPattern_ConstantValue,
        VertexColorPattern_MonoStripe,
        VertexColorPattern_VerticalGradient,
        VertexColorPattern_HorizontalGradient,
        VertexColorPattern_GradientDoubleSided,
        VertexColorPattern_RgbStripe,
        VertexColorPattern_RgbStripeGradient,
        VertexColorPattern_RgbStripeSqueeze,
        VertexColorPattern_RgbStripeSqueezeGradient,
        VertexColorPattern_CountMax
    };

    // 縦方向の分割数
    static const int VerticalDivisionNumber = 12;
    // 横方向の分割数
    static const int HorizontalDivisionNumber = VerticalDivisionNumber * 2;
    // 必要となる頂点配列のサイズ
    static const int VertexArraySize = (VerticalDivisionNumber * HorizontalDivisionNumber) + VerticalDivisionNumber + HorizontalDivisionNumber - 1;
    // 必要となるポリゴンの数
    static const int PolygonFaceCount = (VerticalDivisionNumber * HorizontalDivisionNumber * 2) - HorizontalDivisionNumber * 2;

    uint32_t FaceTable[PolygonFaceCount * 3];
    nn::util::Float2 VertexUv[VertexArraySize];
    nn::util::Float3 VertexPos[VertexArraySize];
    nn::util::Float4 VertexColor[VertexColorPattern_CountMax][VertexArraySize];

    void Make() NN_NOEXCEPT;
};
