﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_BitTypes.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "HidSimple_ApplicationHeap.h"

ApplicationHeap::ApplicationHeap() NN_NOEXCEPT
    : m_pMemoryHeap(0)
{
}

void ApplicationHeap::Initialize(size_t size) NN_NOEXCEPT
{
    m_pMemoryHeap = new nn::Bit8[size];

    m_ApplicationHeapHandle.Initialize(m_pMemoryHeap, size);
}

void ApplicationHeap::Finalize() NN_NOEXCEPT
{
    m_ApplicationHeapHandle.Finalize();

    delete[] reinterpret_cast<nn::Bit8*>(m_pMemoryHeap);
}

void* ApplicationHeap::Allocate(size_t size, size_t alignment) NN_NOEXCEPT
{
    return m_ApplicationHeapHandle.Allocate(size, alignment);
}

void* ApplicationHeap::Allocate(size_t size) NN_NOEXCEPT
{
    return this->Allocate(size, sizeof(void*));
}

void ApplicationHeap::Deallocate(void* ptr) NN_NOEXCEPT
{
    if (ptr != 0)
    {
        m_ApplicationHeapHandle.Free(ptr);
    }
}
