﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include "HidNpadIntegrate_SettingApiPluginBase.h"

class SettingScreen
{
    NN_DISALLOW_COPY(SettingScreen);
    NN_DISALLOW_MOVE(SettingScreen);

public:
    SettingScreen() NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Run(nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;
    void CheckNpadButtons() NN_NOEXCEPT;

protected:
    int GetMenuIndex() const NN_NOEXCEPT;

private:
    int                              m_CurrentProcessor;
    int                              m_NextProcessor;
    nn::hid::NpadIdType              m_NpadId;
    int                              m_MenuSelection;
    nn::hid::NpadButtonSet           m_PreviousButtonState[NpadIdMax];
};

void InitializeSettingScreen() NN_NOEXCEPT;
void FinalizeSettingScreen() NN_NOEXCEPT;
void SettingScreenMain(nn::gfx::util::DebugFontTextWriter& textWriter) NN_NOEXCEPT;
