﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "HidNpadIntegrate_PluginManager.h"
#include "HidNpadIntegrate_SettingApi.h"
#include "HidNpadIntegrate_SettingApiPluginBase.h"

class SetSupportedNpadStyleSetApiState : public SettingApiPluginBase
{
    NN_DISALLOW_COPY(SetSupportedNpadStyleSetApiState);
    NN_DISALLOW_MOVE(SetSupportedNpadStyleSetApiState);

public:
    SetSupportedNpadStyleSetApiState() NN_NOEXCEPT {}

    ~SetSupportedNpadStyleSetApiState() NN_NOEXCEPT NN_OVERRIDE {}

    void Initialize(int* pNextProcessor, int* pMenuSelection) NN_NOEXCEPT NN_OVERRIDE
    {
        SettingApiPluginBase::Initialize(pNextProcessor, pMenuSelection);
        m_NpadStyle = nn::hid::GetSupportedNpadStyleSet();
        for(int i = 0; i < GetPluginManager().GetNpadStylePluginCount(); i++)
        {
            NpadStylePluginBase* pNpad = GetPluginManager().GetNpadStyle(i);
            m_pStyle[i] = new NpadStyleStatus(&m_NpadStyle, i);
            const char* styleName = pNpad->GetName();

            MenuItem styleMenuItem(styleName, m_pStyle[i]);
            m_ReadWriteMenu.push_back(styleMenuItem);
        }
    }

    void Finalize() NN_NOEXCEPT NN_OVERRIDE
    {
        for(int i = 0; i < GetPluginManager().GetNpadStylePluginCount(); i++)
        {
            delete m_pStyle[i];
        }
        SettingApiPluginBase::Finalize();
    }

    void Start() NN_NOEXCEPT NN_OVERRIDE
    {
        if (m_IsApiValid)
        {
            nn::hid::SetSupportedNpadStyleSet(m_NpadStyle);
            m_ResultMsg = "Success";
        }
    }

    void Explain(
        nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        pTextWriter->SetTextColor(Color::White);
        pTextWriter->SetScale(1.0f, 1.0f);

        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->Print("This function sets valid styles on Npad.");
        pTextWriter->SetCursor(OffsetX, OffsetY + 30);
        pTextWriter->Print("Users can specify multiple styles at once.");
    }

    void DrawCaution(
        nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        if(m_NpadStyle.IsAllOff())
        {
            m_IsApiValid = false;
            m_CautionMsg = "This configration is prohibited because controllers don't work at all";
        }
        else
        {
            m_IsApiValid = true;
            m_CautionMsg.clear();
        }
        pTextWriter->SetTextColor(Color::Orange);
        pTextWriter->SetScale(1.2f, 1.2f);
        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->Print("%s", m_CautionMsg.c_str());
    }

private:
    nn::hid::NpadStyleSet m_NpadStyle;
    ReadWriteBase* m_pStyle[NpadStyleMax];
};

namespace {
SET_PLUGIN(SetSupportedNpadStyleSetApiState, "SetSupportedNpadStyleSet");
}
