﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/nn_Common.h>

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include "HidNpadIntegrate_MenuBase.h"
#include "HidNpadIntegrate_PluginBase.h"
#include "HidNpadIntegrate_SettingApi.h"


class SettingApiPluginBase : public PluginBase
{
    NN_DISALLOW_COPY(SettingApiPluginBase);
    NN_DISALLOW_MOVE(SettingApiPluginBase);

public:
    SettingApiPluginBase() NN_NOEXCEPT
        : m_IsApiValid(true)
        , m_CautionMsg("")
        , m_ResultMsg("")
        , m_ResultNum("")
        , m_pCallingApi(NULL) {}

    ~SettingApiPluginBase() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize(int* pNextProcessor,
        int* pMenuSelection) NN_NOEXCEPT
    {
        m_pCallingApi = new CallingApi(pNextProcessor, pMenuSelection);
        MenuItem callingApiMenuItem("Function",
            m_pCallingApi
        );
        m_ReadWriteMenu.push_back(callingApiMenuItem);
    }

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE
    {
        delete m_pCallingApi;
        m_ReadWriteMenu.clear();
    }

    const std::vector<MenuItem>& GetReadWriteMenu() NN_NOEXCEPT
    {
        return m_ReadWriteMenu;
    }

    void ResetResult() NN_NOEXCEPT
    {
        m_ResultMsg.clear();
        m_ResultNum.clear();
    }

    void DrawResult(
        nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY) NN_NOEXCEPT
    {
        pTextWriter->SetTextColor(Color::White);
        pTextWriter->SetScale(1.3f, 1.3f);

        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->Print("Result: %s", m_ResultMsg.c_str());
        pTextWriter->SetScale(0.8f, 0.8f);
        pTextWriter->SetCursor(OffsetX + 50, OffsetY + 25);
        pTextWriter->Print("%s", m_ResultNum.c_str());
    }

    virtual void Start() NN_NOEXCEPT = 0;

    virtual void Explain(nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY) NN_NOEXCEPT = 0;

    virtual void DrawCaution(nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY)  NN_NOEXCEPT
    {
        NN_UNUSED(pTextWriter);
        NN_UNUSED(OffsetX);
        NN_UNUSED(OffsetY);
    };

    virtual bool DrawHoldType(nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY)  NN_NOEXCEPT
    {
        NN_UNUSED(pTextWriter);
        NN_UNUSED(OffsetX);
        NN_UNUSED(OffsetY);

        return false;
    };

    virtual bool DrawAssignment(int index, nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY)  NN_NOEXCEPT
    {
        NN_UNUSED(index);
        NN_UNUSED(pTextWriter);
        NN_UNUSED(OffsetX);
        NN_UNUSED(OffsetY);

        return false;
    };

protected:
    bool m_IsApiValid;
    std::vector<MenuItem> m_ReadWriteMenu;
    std::string m_CautionMsg;
    std::string m_ResultMsg;
    std::string m_ResultNum;
    ReadWriteBase* m_pCallingApi;
};
