﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "HidNpadIntegrate_Pad.h"
#include "HidNpadIntegrate_PluginManager.h"

namespace
{

    void WriteText(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                    const float OffsetX, const float OffsetY,
                    const nn::util::Unorm8x4 TextColor, const char* str) NN_NOEXCEPT
    {
        pTextWriter->SetTextColor(TextColor);
        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->Print(str);
    }

    void WriteNpadState(nn::gfx::util::DebugFontTextWriter* pTextWriter,
                               int no,
                               float offsetX,
                               float offsetY) NN_NOEXCEPT
    {
        nn::hid::NpadStyleSet style = nn::hid::GetNpadStyleSet(NpadIds[no]);
        if(NpadIds[no] == nn::hid::NpadId::Handheld)
        {
            offsetX = 510;
            offsetY = 50;
        }

        pTextWriter->SetScale(1.0f, 1.0f);
        pTextWriter->SetCursor(offsetX, offsetY);
        NpadStylePluginBase* pNpad = GetPluginManager().GetEnableNpad(style);
        if(pNpad != NULL)
        {
            pTextWriter->SetTextColor(Color::White);
            if(NpadIds[no] == nn::hid::NpadId::Handheld)
            {
                pTextWriter->Print("NpadHandheld");
            }
            else
            {
                pTextWriter->Print("NpadID:No.%d, NpadStyle:%s", no, pNpad->GetName());
            }

            pNpad->WriteNpadRightKey(pTextWriter, NpadIds[no], offsetX, offsetY);
            pNpad->WriteNpadLeftKey(pTextWriter, NpadIds[no], offsetX, offsetY);
            pNpad->WriteNpadExtendedKey(pTextWriter, NpadIds[no], offsetX, offsetY);
        }
        else
        {
            pTextWriter->SetTextColor(Color::Gray);
            if(NpadIds[no] == nn::hid::NpadId::Handheld)
            {
                pTextWriter->Print("NpadHandheld");
            }
            else
            {
                pTextWriter->Print("NpadID:No.%d, NpadStyle:---", no);
            }
        }
    }

    // Pad Demoの操作説明を描画します。
    void WritePadDemoGuide(nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT
    {
        pTextWriter->SetScale(1.0f, 1.0f);
        const float OffsetX = 500;
        const float OffsetY = 300;

        WriteText(pTextWriter, OffsetX, OffsetY, Color::White,
                "Connected controllers are displayed in white.");
        WriteText(pTextWriter, OffsetX, OffsetY + 25, Color::White,
                "Pressed buttons are displayed in orange.");
    }

} // namespace

PadDemoScene::PadDemoScene() NN_NOEXCEPT
{
}

PadDemoScene::~PadDemoScene() NN_NOEXCEPT
{
}

void PadDemoScene::InitializeScene(ApplicationHeap* pAppAllocator,
                        GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT
{
    NN_UNUSED(pAppAllocator);
    NN_UNUSED(pGraphicsSystem);
}

void PadDemoScene::FinalizeScene(ApplicationHeap* pAppAllocator) NN_NOEXCEPT
{
    NN_UNUSED(pAppAllocator);
}

void PadDemoScene::StopScene() NN_NOEXCEPT
{
}

void PadDemoScene::RestartScene() NN_NOEXCEPT
{
}

void PadDemoScene::SwitchScene() NN_NOEXCEPT
{
}

void PadDemoScene::ToggleProcess(const nn::hid::NpadButtonSet& Buttons,
                        ApplicationHeap* pAppAllocator,
                        GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT
{
    NN_UNUSED(Buttons);
    NN_UNUSED(pAppAllocator);
    NN_UNUSED(pGraphicsSystem);
}

void PadDemoScene::RunScene(nn::gfx::util::DebugFontTextWriter& textWriter,
        GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT
{
    NN_UNUSED(pGraphicsSystem);

    for (int i = 0; i < NpadIdCountMax; ++i)
    {
        WriteNpadState(&textWriter, i, 60, 50 + 165 * static_cast<float>(i));
    }

    WriteCommonGuide(&textWriter);
    WritePadDemoGuide(&textWriter);
    DrawRect(&textWriter, 490, 275, 65, 10);
}
