﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include "HidNpadIntegrate_Color.h"

class ReadWriteBase
{
    NN_DISALLOW_COPY(ReadWriteBase);
    NN_DISALLOW_MOVE(ReadWriteBase);

public:
    ReadWriteBase() NN_NOEXCEPT {}
    virtual ~ReadWriteBase() NN_NOEXCEPT {}
    virtual void operator()(std::stringstream& sstr) NN_NOEXCEPT
    {
        NN_UNUSED(sstr);
    }
    virtual void operator()(int8_t delta) NN_NOEXCEPT
    {
        NN_UNUSED(delta);
    }
};

class MenuItem
{
public:
    MenuItem(const char* name, ReadWriteBase* pReadWrite) NN_NOEXCEPT;

    void Increment(int8_t delta) const NN_NOEXCEPT;
    void Read(std::stringstream& sstr) const NN_NOEXCEPT;

    const char* GetName() const NN_NOEXCEPT;

private:
    std::string m_Name;
    ReadWriteBase* m_pMenuItemAccessor;
};

void DrawMenu(const std::vector<MenuItem>& Menu,
    const float OffsetX, const float OffsetY,
    int selectIndex,
    nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;
