﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <sstream>

#include <nn/nn_Assert.h>

#include "HidNpadIntegrate_MenuBase.h"

MenuItem::MenuItem(const char* name, ReadWriteBase* pReadWrite) NN_NOEXCEPT
    : m_Name(name)
    , m_pMenuItemAccessor(pReadWrite)
{
}

void MenuItem::Increment(int8_t delta) const NN_NOEXCEPT
{
    (*m_pMenuItemAccessor)(delta);
}

void MenuItem::Read(std::stringstream& sstr) const NN_NOEXCEPT
{
    (*m_pMenuItemAccessor)(sstr);
}

const char* MenuItem::GetName() const NN_NOEXCEPT
{
    return m_Name.c_str();
}

void DrawMenu(const std::vector<MenuItem>& Menu,
    const float OffsetX, const float OffsetY,
    int selectIndex,
    nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT
{

    NN_ASSERT_NOT_NULL(pTextWriter);

    pTextWriter->SetScale(1.0f, 1.0f);

    for (size_t index = 0; index < Menu.size(); index++)
    {
        pTextWriter->SetTextColor(
            (static_cast<size_t>(selectIndex) == index) ? Color::Red : Color::White);
        pTextWriter->SetCursor(OffsetX, OffsetY + index * 30);

        std::stringstream text;
        text << Menu[index].GetName() << ": ";
        Menu[index].Read(text);

        pTextWriter->Print(text.str().c_str());
    }
}
