﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/irsensor.h>

#include "HidNpadIntegrate_Color.h"
#include "HidNpadIntegrate_IrSensor.h"
#include "HidNpadIntegrate_MenuBase.h"

class IrSensorModeStatistics
{
    NN_DISALLOW_COPY(IrSensorModeStatistics);
    NN_DISALLOW_MOVE(IrSensorModeStatistics);

public:
    static const int ResetIntervalsInFrame  = 60 * 3;
    static const int UpdateIntervalsInFrame = 20;

    static const float ExpectedMomentModeFramerate;
    static const float ExpectedClusteringModeFramerate;
    static const float ExpectedHandAnalysisFramerate;

public:
    IrSensorModeStatistics() NN_NOEXCEPT
    : m_FramerateCounter(0)
    , m_FramerateFirstTick(0)
    , m_FramerateFirstSample(0)
    , m_FramerateComputation(0.0f)
    , m_PacketDropPercentage(0.0f)
    {
    }

    void Update(const int64_t* pCurrentSamplingNumber, const float ExpectedFrameRate) NN_NOEXCEPT;
    float* GetPtrPacketDropPercentage() NN_NOEXCEPT
    {
        return &m_PacketDropPercentage;
    }

private:
    uint32_t     m_FramerateCounter;
    nn::os::Tick m_FramerateFirstTick;
    int64_t      m_FramerateFirstSample;
    float        m_FramerateComputation;
    float        m_PacketDropPercentage;
};

class IrSensorModeState
{
    NN_DISALLOW_COPY(IrSensorModeState);
    NN_DISALLOW_MOVE(IrSensorModeState);

public:
    IrSensorModeState(IrSensorMode* pNextProcessor,
        int* pMenuSelection, nn::irsensor::IrCameraHandle irCameraHandle) NN_NOEXCEPT;
    virtual ~IrSensorModeState() NN_NOEXCEPT;

    void AddCommonReadWriteMenu(std::vector<MenuItem>* pMenu,
        ::nn::irsensor::IrCameraConfig* pConfig,
        ::nn::TimeSpanType exposureMin,
        ::nn::TimeSpanType exposureMax) NN_NOEXCEPT;
    void AddCommonReadOnlyMenu(std::vector<MenuItem>* pMenu,
        int64_t* pSamplingNumber,
        nn::irsensor::IrCameraAmbientNoiseLevel* pAmbientNoiseLevel) NN_NOEXCEPT;
    void AddStatisticsMenu(std::vector<MenuItem>* pMenu, float* pPacketLoss) NN_NOEXCEPT;

    const std::vector<MenuItem>& GetReadWriteMenu() NN_NOEXCEPT;
    const std::vector<MenuItem>& GetReadOnlyMenu() NN_NOEXCEPT;

    void Stop() NN_NOEXCEPT;
    virtual void Start() = 0;
    virtual void Update() = 0;
    virtual void Render(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer, int index) = 0;

protected:
    std::vector<MenuItem> m_ReadWriteMenu;
    std::vector<MenuItem> m_ReadOnlyMenu;

    nn::irsensor::IrCameraHandle m_IrCameraHandle;
    IrSensorModeStatistics m_Statistics;
    ReadWriteBase* m_pCurrentMode;
    ReadWriteBase* m_pExposureTime;
    ReadWriteBase* m_pLightTarget;
    ReadWriteBase* m_pDigitalGain;
    ReadWriteBase* m_pNegativeImage;
    ReadWriteBase* m_pSamplingNumber;
    ReadWriteBase* m_pNoiseLevel;
    ReadWriteBase* m_pPacketLoss;
};
