﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/irsensor.h>

#include "HidNpadIntegrate_GraphicsSystem.h"
#include "HidNpadIntegrate_IrSensorHandAnalysisUtil.h"
#include "HidNpadIntegrate_Main.h"
#include "HidNpadIntegrate_ScenePluginBase.h"

enum IrSensorMode
{
    IrSensorMode_Moment = 0,
    IrSensorMode_Clustering = 1,
    IrSensorMode_ImageTransfer = 2,
    IrSensorMode_HandAnalysis = 3,
    IrSensorMode_Count = 4,
};

class IrSensorModeState;

class IrSensorDemo
{
    NN_DISALLOW_COPY(IrSensorDemo);
    NN_DISALLOW_MOVE(IrSensorDemo);

public:
    IrSensorDemo() NN_NOEXCEPT;
    void Initialize(nn::hid::NpadIdType id,
        GraphicsSystem* pGraphicsSystem, void* pImageTransferWorkMemory) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Run(int i, GraphicsSystem* pGraphicsSystem,
        nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;
    void CheckNpadButtons() NN_NOEXCEPT;
    void StartProcessor() NN_NOEXCEPT;
    void StopProcessor() NN_NOEXCEPT;
    nn::irsensor::IrCameraHandle GetIrCameraHandle() NN_NOEXCEPT;

protected:
    int GetMenuIndex() const NN_NOEXCEPT;

private:
    IrSensorMode                     m_CurrentProcessor;
    IrSensorMode                     m_NextProcessor;
    nn::hid::NpadIdType              m_NpadId;
    nn::irsensor::IrCameraHandle     m_IrCameraHandle;
    int                              m_MenuSelection;
    nn::hid::NpadButtonSet           m_PreviousButtonState;
    IrSensorModeState*               m_ModeStates[IrSensorMode_Count];
};

void CreateTexture(GraphicsSystem* pGraphicsSystem,
    int width, int height, nn::gfx::ImageFormat format,
    nn::gfx::Texture* pTexture, nn::gfx::TextureView* pTextureView,
    nn::gfx::DescriptorSlot* pDescriptorSlot) NN_NOEXCEPT;
void CreateSampler(GraphicsSystem* pGraphicsSystem,
    nn::gfx::Sampler* pSampler, nn::gfx::DescriptorSlot* pDescriptorSlot) NN_NOEXCEPT;

class IrSensorDemoScene : public ScenePluginBase
{
    NN_DISALLOW_COPY(IrSensorDemoScene);
    NN_DISALLOW_MOVE(IrSensorDemoScene);

public:
    IrSensorDemoScene() NN_NOEXCEPT;
    virtual ~IrSensorDemoScene() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InitializeScene(ApplicationHeap* pAppAllocator,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT NN_OVERRIDE;
    virtual void FinalizeScene(ApplicationHeap* pAppAllocator) NN_NOEXCEPT NN_OVERRIDE;
    virtual void StopScene() NN_NOEXCEPT NN_OVERRIDE;
    virtual void RestartScene() NN_NOEXCEPT NN_OVERRIDE;
    virtual void SwitchScene() NN_NOEXCEPT NN_OVERRIDE;
    virtual void ToggleProcess(const nn::hid::NpadButtonSet& Buttons,
                                ApplicationHeap* pAppAllocator,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT NN_OVERRIDE;
    virtual void RunScene(nn::gfx::util::DebugFontTextWriter& textWriter,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT NN_OVERRIDE;
};
