﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "./HidControllerSequence_Main.h"

class TitleSceneThread : public ThreadState
{
public:
    static const size_t MenuCount = 4;
    static const size_t NpadStykeCount = 5;

    enum InfoTextType
    {
        InfoTextType_PlayMode = 0,
        InfoTextType_PlayerCount = 1,
        InfoTextType_MasterPlayerNpadId,
        InfoTextType_EnableNpadStyle,
        InfoTextType_Num
    };
private:
    uint64_t            m_FrameCount;
    int32_t             m_SelectMenuNumber;

    std::string         m_MenuText[MenuCount];
    nn::util::Float2    m_MenuSize[MenuCount];
    nn::util::Float2    m_MenuTextPos[MenuCount];

    float               m_StyleIconMargin;
    float               m_StyleIconDrawAreaWidth;
    nn::util::Float2    m_StyleIconSize;
    nn::util::Float2    m_StyleIconPos[NpadStykeCount];

    nns::hid::ButtonSet m_UpButtons;
    nns::hid::ButtonSet m_DownButtons;

    bool                m_IsOpenInfo;
    float               m_InfoLinePos;
    float               m_InfoLineLeftPos;
    std::string         m_InfoText[InfoTextType_Num];
    nn::util::Float2    m_InfoTextPos[InfoTextType_Num];

    nn::util::Float2    m_TitleLogoSize;
    uint64_t            m_AnimationCount;
    uint64_t            m_AnimationCountMax;   // アニメーションの周期(フレーム)

    nns::gfx::PrimitiveRenderer::Renderer*  m_pRenderer;
    nn::gfx::util::DebugFontTextWriter*     m_pTextWriter;
    nn::gfx::CommandBuffer*                 m_pCommand;
public:
    TitleSceneThread();
    TitleSceneThread(const char* name, nn::os::ThreadFunction func);

    void Initialize();
    void Update();
    void Draw();
    void Finalize();

    void UpdateInfo();
    void ShowInfo();
};
