﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>
#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

namespace nn     {
namespace fgm    {
namespace sample {

class Worker
{

private:
    static const size_t ThreadStackSize = (16 * 1024);

    NN_OS_ALIGNAS_THREAD_STACK uint8_t
                              m_Stack[ThreadStackSize];
    nn::os::ThreadType        m_Thread;
    std::function<void(void)> m_Function;

    void Thread()
    NN_NOEXCEPT
    {
        m_Function();
    }

    static void ThreadEntry(void* argument)
    NN_NOEXCEPT
    {
        Worker* p = (Worker*)argument;
        p->Thread();
    }

public:

    nn::Result Initialize(std::function<void(void)>function, int priority)
    NN_NOEXCEPT
    {
        m_Function = function;
        nn::os::CreateThread(&m_Thread, ThreadEntry, this, m_Stack, sizeof(m_Stack), priority);
        nn::os::StartThread(&m_Thread);
        return ResultSuccess();
    }

    void Finalize()
    NN_NOEXCEPT
    {
        nn::os::WaitThread(&m_Thread);
        nn::os::DestroyThread(&m_Thread);
    }
};

}}}
