﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/ovln/ovln_ReceiverForOverlay.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/os.h>

// Notifier TODO: ここにディスパッチ関数への先行宣言を追加してください。
//   - 関数名の昇順で並べてください。
//   - 関数本体はここには書かないでください。
void DispatchAudioMessage(const nn::ovln::Message& message) NN_NOEXCEPT;
void DispatchCapsrvMessage(const nn::ovln::Message& message) NN_NOEXCEPT;
void DispatchControllerMessage(const nn::ovln::Message& message) NN_NOEXCEPT;
void DispatchDownloadMessage(const nn::ovln::Message& message) NN_NOEXCEPT;
void DispatchPowerManagementMessage(const nn::ovln::Message& message) NN_NOEXCEPT;
void DispatchSampleMessage(const nn::ovln::Message& message) NN_NOEXCEPT;

namespace {

struct Entry
{
    uint32_t tagMin;
    uint32_t tagMax;
    void (*dispatch)(const nn::ovln::Message& message);
};

Entry g_Entries[] =
{
    // Notifier TODO: ここにタグの範囲とディスパッチ関数へのポインタを追加してください。
    //  - タグの昇順に追加してください。
    //  - 範囲には、終端の数値を含みます。
    //  - 末尾のカンマは必ず付けてください。
    {   1000,   1999, &DispatchAudioMessage,  },
    {   3000,   3999, &DispatchPowerManagementMessage, },
    {   5000,   5999, &DispatchDownloadMessage, },
    {   6000,   6999, &DispatchControllerMessage, },
    {   8000,   8999, &DispatchCapsrvMessage, },
    { 100000, 109999, &DispatchSampleMessage, },
};

void ProcessMessage(const nn::ovln::Message& message) NN_NOEXCEPT
{
    for (auto&& e: g_Entries)
    {
        if (e.tagMin <= message.tag && message.tag <= e.tagMax)
        {
            e.dispatch(message);
            return;
        }
    }
    NN_LOG("[DevOverlayDisplay] unknown message: tag = %u\n", message.tag);
}

}

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    NN_LOG("0\n");

    // 受信ライブラリの初期化
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::ovln::InitializeReceiverLibraryForOverlay());
    NN_UTIL_SCOPE_EXIT
    {
        nn::ovln::FinalizeReceicerLibraryForOverlay();
    };

    NN_LOG("1\n");

    // Receiver の初期化
    nn::ovln::ReceiverForOverlayType receiver;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::ovln::InitializeReceiver(&receiver));
    NN_UTIL_SCOPE_EXIT
    {
        nn::ovln::FinalizeReceiver(&receiver);
    };

    NN_LOG("2\n");

    // コントローラーの接続を許可する
    nn::hid::NpadIdType ids[] = { nn::hid::NpadId::No1, nn::hid::NpadId::No2, nn::hid::NpadId::No3, nn::hid::NpadId::No4 };
    nn::hid::InitializeNpad();
    nn::hid::SetSupportedNpadIdType(ids, sizeof(ids) / sizeof(ids[0]));
    nn::hid::SetSupportedNpadStyleSet(nn::hid::NpadStyleJoyDual::Mask);

    // メッセージループ
    for (;;)
    {
        nn::ovln::Message message;
        nn::ovln::Receive(&message, &receiver);
        ProcessMessage(message);
    }
}
