﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Demo1ScenePluginBase.h"

class SixAxisSensorDemo : public ScenePluginBase
{
    NN_DISALLOW_COPY(SixAxisSensorDemo);
    NN_DISALLOW_MOVE(SixAxisSensorDemo);
public:
    SixAxisSensorDemo() NN_NOEXCEPT {} ;
    virtual ~SixAxisSensorDemo() NN_NOEXCEPT NN_OVERRIDE {} ;

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Draw() NN_NOEXCEPT NN_OVERRIDE;

    bool CreateSixAxisSensor(const nn::hid::NpadIdType& id) NN_NOEXCEPT;

private:
    void MakeCommand(int64_t frame, const char* pName) NN_NOEXCEPT;

private:
    //!< 管理対象の操作形態を格納するコンテナーです。(INpadStyleSixAxisSensor)
    std::vector<void*> m_NpadStyleSixAxisSensors;
};
