﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_Npad.h>

#include "Demo1Color.h"
#include "Demo1Plugin.h"

namespace {
const nn::hid::NpadIdType NpadIds[] = {
    nn::hid::NpadId::No1,
    nn::hid::NpadId::No2,
    nn::hid::NpadId::No3,
    nn::hid::NpadId::No4,
    nn::hid::NpadId::No5,
    nn::hid::NpadId::No6,
    nn::hid::NpadId::No7,
    nn::hid::NpadId::No8,
    nn::hid::NpadId::Handheld,
};
}

struct NpadCommonState
{
    nn::hid::NpadButtonSet buttons;              //!< Npad のデジタルボタンの状態です。
    nn::hid::AnalogStickState analogStickL;      //!< Npad の左アナログスティックの状態です。
    nn::hid::AnalogStickState analogStickR;      //!< Npad の右アナログスティックの状態です。
};

class NpadPluginBase : public PluginBase
{
    NN_DISALLOW_COPY(NpadPluginBase);
    NN_DISALLOW_MOVE(NpadPluginBase);
public:
    NpadPluginBase() NN_NOEXCEPT {}

    virtual ~NpadPluginBase() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Procedure() NN_NOEXCEPT NN_OVERRIDE {}

    virtual bool IsEnableNpadStyle(nn::hid::NpadStyleSet style) NN_NOEXCEPT = 0;

    virtual nn::hid::NpadStyleSet  GetNpadStyleSet() NN_NOEXCEPT = 0;

    virtual NpadCommonState GetNpadButtonState(nn::hid::NpadIdType id) NN_NOEXCEPT = 0;

    virtual nn::util::Color4u8Type GetMenuTextColor() NN_NOEXCEPT = 0;

    virtual std::string GetNpadButtonStateString(nn::hid::NpadButtonSet state) NN_NOEXCEPT = 0;
};
