﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#define NN_PERF_PROFILE_ENABLED

#include <nn/perf.h>

#include <nn/hid/hid_NpadJoy.h>
#include <nn/util/util_Color.h>
#include <nn/util/util_FormatString.h>

#include "Demo1.h"
#include "Demo1NpadPluginBase.h"
#include "Demo1PluginManager.h"

class NpadJoyDual : public NpadPluginBase
{
    NN_DISALLOW_COPY(NpadJoyDual);
    NN_DISALLOW_MOVE(NpadJoyDual);

public:
    NpadJoyDual() NN_NOEXCEPT {}

    virtual ~NpadJoyDual() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual bool IsEnableNpadStyle(nn::hid::NpadStyleSet style) NN_NOEXCEPT NN_OVERRIDE
    {
        return style.Test<nn::hid::NpadStyleJoyDual>();
    }

    virtual nn::hid::NpadStyleSet GetNpadStyleSet() NN_NOEXCEPT NN_OVERRIDE
    {
        return nn::hid::NpadStyleJoyDual::Mask;
    }

    virtual NpadCommonState GetNpadButtonState(nn::hid::NpadIdType id) NN_NOEXCEPT NN_OVERRIDE
    {
        nn::hid::NpadJoyDualState keyState;
        nn::hid::GetNpadState(&keyState, id);
        NpadCommonState state = { keyState.buttons ,
                                  keyState.analogStickL ,
                                  keyState.analogStickR};
        return state;
    }

    virtual nn::util::Color4u8Type GetMenuTextColor() NN_NOEXCEPT NN_OVERRIDE
    {
        return nn::util::Color4u8::Cyan();
    }

    virtual std::string GetNpadButtonStateString(
            nn::hid::NpadButtonSet state) NN_NOEXCEPT NN_OVERRIDE
    {
        std::string str;

        str += (state.Test<nn::hid::NpadButton::A>()) ? 'A' : '_';
        str += (state.Test<nn::hid::NpadButton::B>()) ? 'B' : '_';
        str += (state.Test<nn::hid::NpadButton::X>()) ? 'X' : '_';
        str += (state.Test<nn::hid::NpadButton::Y>()) ? 'Y' : '_';
        str += (state.Test<nn::hid::NpadButton::StickL>()) ? 'L' : '_';
        str += (state.Test<nn::hid::NpadButton::StickL>()) ? 'S' : '_';
        str += (state.Test<nn::hid::NpadButton::StickR>()) ? 'R' : '_';
        str += (state.Test<nn::hid::NpadButton::StickR>()) ? 'S' : '_';
        str += (state.Test<nn::hid::NpadButton::L>()) ? 'L' : '_';
        str += (state.Test<nn::hid::NpadButton::R>()) ? 'R' : '_';
        str += (state.Test<nn::hid::NpadButton::ZL>()) ? 'Z' : '_';
        str += (state.Test<nn::hid::NpadButton::ZL>()) ? 'L' : '_';
        str += (state.Test<nn::hid::NpadButton::ZR>()) ? 'Z' : '_';
        str += (state.Test<nn::hid::NpadButton::ZR>()) ? 'R' : '_';
        str += (state.Test<nn::hid::NpadButton::Plus>()) ? '+' : '_';
        str += (state.Test<nn::hid::NpadButton::Minus>()) ? '-' : '_';
        str += (state.Test<nn::hid::NpadButton::Left>()) ? '<' : '_';
        str += (state.Test<nn::hid::NpadButton::Up>()) ? '^' : '_';
        str += (state.Test<nn::hid::NpadButton::Right>()) ? '>' : '_';
        str += (state.Test<nn::hid::NpadButton::Down>()) ? 'v' : '_';
        str += (state.Test<nn::hid::NpadJoyButton::LeftSL>()) ? 'S' : '_';
        str += (state.Test<nn::hid::NpadJoyButton::LeftSL>()) ? 'L' : '_';
        str += (state.Test<nn::hid::NpadJoyButton::LeftSR>()) ? 'S' : '_';
        str += (state.Test<nn::hid::NpadJoyButton::LeftSR>()) ? 'R' : '_';
        str += (state.Test<nn::hid::NpadJoyButton::RightSL>()) ? 'S' : '_';
        str += (state.Test<nn::hid::NpadJoyButton::RightSL>()) ? 'L' : '_';
        str += (state.Test<nn::hid::NpadJoyButton::RightSR>()) ? 'S' : '_';
        str += (state.Test<nn::hid::NpadJoyButton::RightSR>()) ? 'R' : '_';
        str += (state.Test<nn::hid::NpadButton::StickLRight>()) ? '>' : '_';
        str += (state.Test<nn::hid::NpadButton::StickLUp>()) ? '^' : '_';
        str += (state.Test<nn::hid::NpadButton::StickLLeft>()) ? '<' : '_';
        str += (state.Test<nn::hid::NpadButton::StickLDown>()) ? 'v' : '_';
        str += (state.Test<nn::hid::NpadButton::StickRRight>()) ? '>' : '_';
        str += (state.Test<nn::hid::NpadButton::StickRUp>()) ? '^' : '_';
        str += (state.Test<nn::hid::NpadButton::StickRLeft>()) ? '<' : '_';
        str += (state.Test<nn::hid::NpadButton::StickRDown>()) ? 'v' : '_';

        return str;
    }
};

namespace {
SET_PLUGIN( "JoyDual", NpadJoyDual, PluginProperty_None );
}
