﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>

#include <nn/hid.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/hid/hid_KeyboardKey.h>
#include <nn/hid/hid_Npad.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Thread.h>
#include <nn/TargetConfigs/build_Platform.h>

#include "Demo1Color.h"
#include "Demo1NpadPluginBase.h"
#include "Demo1ScenePluginBase.h"

class NpadDemo : public ScenePluginBase
{
    NN_DISALLOW_COPY(NpadDemo);
    NN_DISALLOW_MOVE(NpadDemo);
public:
    NpadDemo() NN_NOEXCEPT
    : m_MutexState(false)
    , m_MutexIndex(false)
    , m_SceneChangeCount(0)
    , m_IsPrePressedMinus(false)
    , m_IsPrePressedPlus(false)
    {}
    virtual ~NpadDemo() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;

    virtual void End() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Draw() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Wait() NN_NOEXCEPT NN_OVERRIDE;

    bool GetEventEnd() NN_NOEXCEPT;
    int  GetSceneChangeCount() NN_NOEXCEPT;
    bool EndTrigger() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;

private:
    static const size_t ThreadStackSize = nn::os::ThreadStackAlignment * 3;

private:
    void NpadThreadImpl() NN_NOEXCEPT;
    static void NpadThread(void* pArg) NN_NOEXCEPT;

    void SetNpadStickState(const NpadCommonState state) NN_NOEXCEPT;
    void SetWriter(
        nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float offsetX,
        const float offsetY,
        size_t stepCounter,
        const size_t npadNum) NN_NOEXCEPT;
    void WriteNpadStickState(nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;
    void UpdateNpadState() NN_NOEXCEPT;
    void DrawNpadStates() NN_NOEXCEPT;
    void MakeCommand(int64_t frame, const char* pName) NN_NOEXCEPT;

private:
    std::string m_CurrentString;
    std::vector<std::string> m_OutString;
    std::string m_CurrentStick;
    std::vector<std::string> m_OutStick;

    // NPAD の状態を保護する Mutex
    nn::os::Mutex m_MutexState;

    // m_DrawIndexNpadを保護する Mutex
    nn::os::Mutex m_MutexIndex;
    int m_SceneChangeCount;
    nn::os::ThreadType m_NpadThread;
    bool m_IsPrePressedMinus; // 前の検査で Minus ボタンが押されていたかどうか
    bool m_IsPrePressedPlus;  // 前の検査で Plus  ボタンが押されていたかどうか

    char*  m_pThreadStack;
};
