﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/irsensor.h>

#include "Demo1IrSensorDemo.h"

class ReadWriteBase
{
public:
    ReadWriteBase() NN_NOEXCEPT {}
    virtual ~ReadWriteBase() NN_NOEXCEPT {}
    virtual void operator()(std::stringstream& sstr) NN_NOEXCEPT = 0;
    virtual void operator()(int8_t delta) NN_NOEXCEPT = 0;
};


class MenuItem
{
public:
    MenuItem(const char* pName, ReadWriteBase* pReadWrite) NN_NOEXCEPT;

    void Increment(int8_t delta) const NN_NOEXCEPT;
    void Read(std::stringstream& sstr) const NN_NOEXCEPT;

    const char* GetName() const NN_NOEXCEPT;

private:
    std::string m_Name;
    ReadWriteBase* m_pMenuItemAccessor;
};

class IrSensorModeState
{
public:
    IrSensorModeState(
        IrSensorMode* pNextProcessor,
        int* pMenuSelection,
        nn::irsensor::IrCameraHandle irCameraHandle) NN_NOEXCEPT;
    virtual ~IrSensorModeState() NN_NOEXCEPT;

    void AddCommonReadWriteMenu(
        std::vector<MenuItem>* pMenu,
        ::nn::irsensor::IrCameraConfig* pConfig,
        ::nn::TimeSpanType exposureMin,
        ::nn::TimeSpanType exposureMax
    ) NN_NOEXCEPT;
    void AddCommonReadOnlyMenu(
        std::vector<MenuItem>* pMenu,
        int64_t* pSamplingNumber,
        nn::irsensor::IrCameraAmbientNoiseLevel* pAmbientNoiseLevel
    ) NN_NOEXCEPT;

    const std::vector<MenuItem>& GetReadWriteMenu() const NN_NOEXCEPT;
    const std::vector<MenuItem>& GetReadOnlyMenu() const NN_NOEXCEPT;

    void Stop() const NN_NOEXCEPT;
    virtual void Start() NN_NOEXCEPT = 0;
    virtual void Update() NN_NOEXCEPT = 0;
    virtual void Render(
        nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer,
        int index) NN_NOEXCEPT = 0;

protected:
    std::vector<MenuItem> m_ReadWriteMenu;
    std::vector<MenuItem> m_ReadOnlyMenu;

    nn::irsensor::IrCameraHandle m_IrCameraHandle;
    ReadWriteBase* m_pCurrentMode;
    ReadWriteBase* m_pExposureTime;
    ReadWriteBase* m_pLightTarget;
    ReadWriteBase* m_pDigitalGain;
    ReadWriteBase* m_pNegativeImage;
    ReadWriteBase* m_pSamplingNumber1;
    ReadWriteBase* m_pSamplingNumber2;
};
