﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BitStreamReader.h"

class AdtsHeaderReader
{
public:
    AdtsHeaderReader(void* pBitStream, size_t size);

    int GetSampleRate() const;

    int GetChannelCount() const;

    size_t GetFrameLength() const;

    size_t GetHeaderSize() const;

private:
    BitStreamReader m_BitStreamReader;
    int m_SampleRate;
    int m_ChannelCount;
    size_t m_FrameLength;
    size_t m_HeaderSize;
};
