﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "bluetooth_Client.h"
#include <cstdlib>

class myBtClient : public bluetoothClient
{
    void EventFromConnectionStateCallback(const nn::bluetooth::InfoFromConnectionStateCallback* pInfo)
    {
        bluetoothClient::EventFromConnectionStateCallback(pInfo);

        if(pInfo->state==nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            setTsi(pInfo->bluetoothAddress, 8);
        }
    }

    void EventFromExtensionCallbacks(const nn::bluetooth::InfoFromExtensionCallbacks* pInfo)
    {
        bluetoothClient::EventFromExtensionCallbacks(pInfo);

        if(pInfo->eventType==nn::bluetooth::EventFromTsiSetCallback)
        {
#if 0
            //TSI# is changed.
            //Send the HID command.
            nn::bluetooth::HidData hidData;
            memset(&hidData, 0, sizeof(hidData));
            hidData.length=49;
            hidData.data[0]=0x01;
            hidData.data[10]=0x02;
            NN_LOG("  [HidSendData] %s\n", toHexString(pInfo->bluetoothAddress));
            nn::bluetooth::HidSendData(&pInfo->bluetoothAddress, &hidData);
#elif 0
            uint8_t reportIds[] = { 5, 4, 3, 2 };
            NN_LOG("  [ExtSetZeroRetran] %s\n", toHexString(pInfo->bluetoothAddress));
            nn::bluetooth::ExtSetZeroRetran(&pInfo->bluetoothAddress, sizeof(reportIds), reportIds);
#elif 1
            bool enable = 0;
            NN_LOG("  [ExtSetMcMode] en=%d\n", enable);
            nn::bluetooth::ExtSetMcMode(enable);
#endif
        }
    }
};


static myBtClient client;

//-----------------------------------------------------------------------------
extern "C" void nnMain()
{
    NN_LOG("myBtClient NOW RUNNING \n");

    client.startBluetooth();

    int loopTimeMs=0;

    bool enable = 1;
    NN_LOG("  [ExtSetMcMode] en=%d \n", enable);
    nn::bluetooth::ExtSetMcMode(enable);


    // try pairing every 30 seconds for 5 minutes, then try to stop Bluetooth
    while (1) //(loopTimeMs < 5*60*1000)
    {
        if ((loopTimeMs % 1000) == 0)
            client.printControllerHidCount();

        if((loopTimeMs % 30000)==0)
        {
            //Discovery
            NN_LOG("  [StartDiscovery]\n");
            nn::bluetooth::StartDiscovery();
        }
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
        loopTimeMs += 100;
    }

    NN_LOG("  [Exiting...]\n");
    client.finishBluetooth();
}



