﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../AtkSandboxCommon.h"
#include "ICheckModule.h"

class StreamSoundCheckModule : public ICheckModule
{
public:
    virtual void OnInitializeAtk() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnFinalizeAtk() NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnLoadData() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnPrintUsage() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateInput() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateAtk() NN_NOEXCEPT NN_OVERRIDE;
#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    virtual void OnUpdateDraw() NN_NOEXCEPT NN_OVERRIDE;
#endif

    virtual const char* GetModuleName() const NN_NOEXCEPT NN_OVERRIDE
    {
        return "StreamSound";
    }

    virtual FlagList& GetLocalFlagList() NN_NOEXCEPT NN_OVERRIDE;

private:
    void LoadPrefetchStreamData() NN_NOEXCEPT;
    void PlayExStrmWithStartSound(nn::atk::SoundArchive::ItemId soundId, const char* debugLabelName) NN_NOEXCEPT;
    void PlayExOnMemStrmWithStartSound(nn::atk::SoundArchive::ItemId soundId, const char* debugLabelName) NN_NOEXCEPT;
    void PlayOpusStrmWithStartSound(nn::atk::SoundArchive::ItemId soundId, const char* debugLabelName) NN_NOEXCEPT;
    void UpdateEstimateRegionEndTick() NN_NOEXCEPT;
#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    void DrawRestRegionTime() NN_NOEXCEPT;
#endif

private:
    CommonObject m_CommonObject;
    void* m_pMemoryForBfstpFile;
    bool m_IsPause;
    nn::os::Tick m_EstimatedRegionEndTick;
};
