﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class FlagList;

class ICheckModule
{
public:
    virtual void OnInitializeAtk() NN_NOEXCEPT = 0;
    virtual void OnFinalizeAtk() NN_NOEXCEPT = 0;

    virtual void OnLoadData() NN_NOEXCEPT = 0;
    virtual void OnPrintUsage() NN_NOEXCEPT = 0;
    virtual void OnPostPrintUsage() NN_NOEXCEPT {}
    virtual void OnUpdateInput() NN_NOEXCEPT = 0;
    virtual void OnUpdateAtk() NN_NOEXCEPT = 0;
    virtual void OnUpdateDraw() NN_NOEXCEPT = 0;

    virtual const char* GetModuleName() const NN_NOEXCEPT = 0;

    virtual FlagList& GetLocalFlagList() NN_NOEXCEPT = 0;
};
