﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "AccountSelection.h"
#include "AccountSelection_ScreenIo.h"

#include <nn/account/account_ApiForApplications.h>
#include <nns/console/console_ConsoleManager.h>
#include <nns/console/console_InputManager.h>

namespace
{

// コンソールとその描画を管理するための領域。巨大&アラインメントの制約があるので基本的に名前空間直下に配置する。
nns::console::DefaultConsoleManagerHolder g_ManagerHolder = NNS_CONSOLE_CONSOLE_MANAGER_HOLDER_INITIALIZER;

} // ~namespace <anonymous>

// ログ記録用
Logger g_Logger;

extern "C" void nnMain()
{
    nn::account::Initialize();

    // コンソールマネージャと HID の初期化
    auto& manager = g_ManagerHolder.GetManager();
    nns::console::DefaultInputManager im;
    im.Initialize();

    Window window;
    RootSequence root(window);

    const auto Margin = 40;
    const auto Width =  static_cast<int>(manager.Settings.ScreenWidth);
    const auto TotalHeight = (static_cast<int>(manager.Settings.ScreenHeight) - Margin);
    const auto WindowHeight = TotalHeight / 2;
    const auto LogHeight = TotalHeight - WindowHeight;


    manager.Register(&window, 0, 0, Width, WindowHeight);
    manager.Register(&g_Logger, 0, WindowHeight + Margin, Width, LogHeight);
    im.SetPadEventListener(&window);

    // 処理と描画
    while (NN_STATIC_CONDITION(true))
    {
        im.Update();
        auto* subSeq = root.GetSubSequence();
        if (subSeq && !subSeq->IsClosed())
        {
            subSeq->Update();
        }
        else
        {
            root.Update();
        }
        window.Update();

        manager.Update();
        manager.Draw();
    }
}
