﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include "g3ddemo_DemoUtility.h"
#include <nns/gfx/gfx_DebugGraphicsFramework.h>
#include <nns/g3d.h>

void InitializeMenu() NN_NOEXCEPT;
void UpdateMenu() NN_NOEXCEPT;
void DrawMenu(nn::gfx::CommandBuffer* pCommandBuffer) NN_NOEXCEPT;

class MenuContext
{
public:

    static const int InvalidIndex = -1;

    enum SelectedInfo
    {
        SelectedInfo_Model,
        SelectedInfo_Shape,
        SelectedInfo_SubMesh,
        SelectedInfo_Bone,
        SelectedInfo_Count
    };

    enum DrawConfigType
    {
        DrawConfigType_Wireframe,
        DrawConfigType_Skeleton,
        DrawConfigType_BoundingSphere,
        DrawConfigType_BoundingBox,
        DrawConfigType_SigleShape,
        DrawConfigType_SingleSubMesh,
        DrawConfigType_BoneWeight,
        DrawConfigType_VertexNormal,
        DrawConfigType_Count,
    };

    MenuContext() NN_NOEXCEPT
        : m_DrawConfigs(0)
    {
        for (int selectedInfoIndex = 0; selectedInfoIndex < SelectedInfo_Count; ++selectedInfoIndex)
        {
            m_SelectedIndecies[selectedInfoIndex] = InvalidIndex;
        }
    }

    int GetSelectedIndex(SelectedInfo info) const NN_NOEXCEPT
    {
        NN_ASSERT_RANGE(info, 0, SelectedInfo_Count);
        return m_SelectedIndecies[static_cast<int>(info)];
    }

    bool IsDrawConfigEnabled(DrawConfigType flag) const NN_NOEXCEPT
    {
        NN_ASSERT_RANGE(flag, 0, DrawConfigType_Count);
        return (m_DrawConfigs & (1 << flag)) != 0;
    }

    int* GetSelectedIndeciesArray() NN_NOEXCEPT
    {
        return m_SelectedIndecies;
    }

    nn::Bit32* GetDrawConfig() NN_NOEXCEPT
    {
        return &m_DrawConfigs;
    }

private:
    int m_SelectedIndecies[SelectedInfo_Count];
    nn::Bit32 m_DrawConfigs;
};

const MenuContext* GetMenuContext() NN_NOEXCEPT;
void SetSelectedIndex(MenuContext::SelectedInfo info, int value, bool isForceBind) NN_NOEXCEPT;
void SetSelectedIndex(MenuContext::SelectedInfo info, int value) NN_NOEXCEPT;
void SelectInfo(MenuContext::SelectedInfo info) NN_NOEXCEPT;
MenuContext::SelectedInfo GetSelectedInfo() NN_NOEXCEPT;
void WriteVisializeInfoKey(nns::g3d::RenderModelObj* pRenderModelObj) NN_NOEXCEPT;
