﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/demo_Utility.h>

namespace nw
{
namespace demo
{

//----------------------------------------
u8 SRGBToLinear(u8 src)
{
    const f32 c = static_cast<f32>(src) * (1.f / 255.f);
    if (c <= 0.04045f)
    {
        return static_cast<u8>((c / 12.92f) * 255.f);
    }
    else
    {
        return static_cast<u8>((std::pow(((c + 0.055f) / 1.055f), 2.4f) * 255.f));
    }
}

//----------------------------------------
u8 LinearToSRGB(u8 src)
{
    const f32 c = static_cast<f32>(src) * (1.f / 255.f);
    if (c <= 0.0031308f)
    {
       return static_cast<u8>(12.92f * c * 255.f);
    }
    else
    {
       return static_cast<u8>(((1.055f * std::pow(c, 1.0f / 2.4f)) - 0.055f) * 255.f);
    }
}

}
}
